const express = require("express");
const router = express.Router();
const categoryController = require("../controllers/categoryController");
const {
  uploadCategoryIcon,
} = require("../storage/middlewareStorage/uploadCategoryMedia");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

// --- Public Routes (API Key Protected) ---
router.route("/").get(checkApiKey, categoryController.getAllCategories);

router.route("/:id").get(checkApiKey, categoryController.getCategory);

// --- Protected Routes (Admin Only) ---
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").post(uploadCategoryIcon, categoryController.createCategory);

router
  .route("/:id")
  .patch(uploadCategoryIcon, categoryController.updateCategory)
  .delete(categoryController.deleteCategory);

module.exports = router;
